#ifndef __CFontEnumerator__
#define __CFontEnumerator__

#include "CFontReference.hpp"
#include <Collections/TCountedPointerArray.hpp>
#include <Basics/CString.hpp>

//  ===========================================================================

using Exponent::GUI::Fonts::CFontReference;
using Exponent::Collections::TCountedPointerArray;
using Exponent::Basics::CString;

//  ===========================================================================

namespace Exponent
{
	namespace GUI
	{
		namespace Fonts
		{
			/**
			 * @class CFontEnumerator CFontEnumerator.hpp
			 * @brief Enumerates available system font
			 *
			 * @date 21/09/2004
			 * @author Paul Chana
			 * @version 1.0.0 Initial version
			 *
			 * @note All contents of this source code are copyright 2005 Exp Digital Uk.\n
			 * This source file is covered by the licence conditions of the Infinity API. You should have recieved a copy\n
			 * with the source code. If you didnt, please refer to http://www.expdigital.co.uk
			 * All content is the Intellectual property of Exp Digital Uk.\n
			 * Certain sections of this code may come from other sources. They are credited where applicable.\n
			 * If you have comments, suggestions or bug reports please visit http://support.expdigital.co.uk
			 *
			 * $Id: CFontEnumerator.hpp,v 1.3 2007/02/08 21:07:54 paul Exp $
			 */
			class CFontEnumerator
			{
			public:

				/**
				 * Construction
				 */
				CFontEnumerator();

				/**
				 * Destruction
				 */
				virtual ~CFontEnumerator();

//  ===========================================================================

				/**
				 * Get the font list
				 * @retval TCountedPointerArray<CFontReference> * The font array
				 */
				TCountedPointerArray<CFontReference> *getMutableFontArray() const { return m_fontArray; }

				/**
				 * Get hte font list
				 * @retval const TCountedPointerArray<CFontReference> * The font array
				 */
				const TCountedPointerArray<CFontReference> *getFontArray() const { return m_fontArray; }

				/**
				 * Does the font exist
				 * @param fontName The name of the font
				 * @retval bool True if font is installed on system and available, false otherwise
				 */
				bool fontExists(const CString &fontName);

//  ===========================================================================

			protected:

//  ===========================================================================

				/**
				 * Find the fonts
				 */
				void findFonts();

//  ===========================================================================

				#ifdef WIN32
					/**
					 * Handle the enumeration process
					 * @param logFontEx Windows ENUMLOGFONTEX
					 * @param metric Windows NEWTEXTMETRICEX
					 * @param fontType Windows type of font
					 * @retval long Windows specific
					 */
					virtual long handleEnumerationEvent(ENUMLOGFONTEX *logFontEx, NEWTEXTMETRICEX *metric, int fontType);

					/**
					 * Enumerate the fonts
					 * @param logFontEx Windows ENUMLOGFONTEX
					 * @param metric Windows NEWTEXTMETRICEX
					 * @param fontType Windows type of font
					 * @param lParam The little byte parameter
					 * @retval long Windows specific
					 */
					static long CALLBACK enumerateProcess(ENUMLOGFONTEX *logFontEx, NEWTEXTMETRICEX *metric, int fontType, LPARAM lParam);
				#endif

//  ===========================================================================

				TCountedPointerArray<CFontReference> *m_fontArray;		/**< The array of font elements */

			};
		}
	}
}
#endif	// End of CFontEnumerator.hpp